/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.h.HinataDawnCrownedEffectUtility;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class HinataDawnCrownedOpponentsEffect
extends CostModificationEffectImpl {
    HinataDawnCrownedOpponentsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, CostModificationType.INCREASE_COST);
        this.staticText = "Spells your opponents cast cost {1} more to cast for each target";
    }

    private HinataDawnCrownedOpponentsEffect(HinataDawnCrownedOpponentsEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public HinataDawnCrownedOpponentsEffect copy() {
        return new HinataDawnCrownedOpponentsEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)HinataDawnCrownedEffectUtility.getTargetCount(game, abilityToModify));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && !abilityToModify.isControlledBy(source.getControllerId());
    }
}

