/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HipparionEffect
extends ReplacementEffectImpl {
    HipparionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "{this} can't block creatures with power 3 or greater unless you pay {1}";
    }

    private HipparionEffect(HipparionEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player == null) {
            return false;
        }
        Permanent hipparion = game.getPermanent(event.getSourceId());
        if (hipparion == null) {
            return false;
        }
        Permanent attacker = game.getPermanent(event.getTargetId());
        if (attacker == null || attacker.getPower().getValue() < 3) {
            return false;
        }
        GenericManaCost cost = new GenericManaCost(1);
        if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Benefit, "Pay {1} to block creature with power 3 or greater?", source, game)) {
            return !cost.pay(source, game, source, player.getId(), false, (Cost)cost);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARE_BLOCKER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId() != null && event.getSourceId().equals(source.getSourceId());
    }

    public HipparionEffect copy() {
        return new HipparionEffect(this);
    }
}

