/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class HiredGiantEffect
extends OneShotEffect {
    HiredGiantEffect() {
        super(Outcome.Detriment);
        this.staticText = "each other player may search their library for a land card and put that card onto the battlefield. Then each player who searched their library this way shuffles";
    }

    private HiredGiantEffect(HiredGiantEffect effect) {
        super((OneShotEffect)effect);
    }

    public HiredGiantEffect copy() {
        return new HiredGiantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<Player> playersThatSearched = new HashSet<Player>(1);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Card targetCard;
                TargetCardInLibrary target;
                Player player;
                if (playerId.equals(controller.getId()) || (player = game.getPlayer(playerId)) == null || !player.chooseUse(Outcome.PutCreatureInPlay, "Search your library for a land card and put it onto the battlefield?", source, game) || !player.searchLibrary(target = new TargetCardInLibrary((FilterCard)new FilterLandCard()), source, game) || (targetCard = player.getLibrary().getCard(target.getFirstTarget(), game)) == null) continue;
                player.moveCards(targetCard, Zone.BATTLEFIELD, source, game);
                playersThatSearched.add(player);
            }
            for (Player player : playersThatSearched) {
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

