/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.SagaAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.SagaChapter;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.AngelVigilanceToken;
import mage.game.permanent.token.Token;
import mage.game.stack.StackObject;
import mage.util.CardUtil;

class HistoriansBoonTriggeredAbility
extends TriggeredAbilityImpl {
    HistoriansBoonTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new AngelVigilanceToken()));
        this.setTriggerPhrase("Whenever the final chapter ability of a Saga you control triggers, ");
    }

    private HistoriansBoonTriggeredAbility(HistoriansBoonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HistoriansBoonTriggeredAbility copy() {
        return new HistoriansBoonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRIGGERED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getTargetId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (stackObject == null || permanent == null || !permanent.isControlledBy(this.getControllerId()) || !permanent.hasSubtype(SubType.SAGA, game)) {
            return false;
        }
        int maxChapter = CardUtil.castStream((Stream)permanent.getAbilities(game).stream(), SagaAbility.class).map(SagaAbility::getMaxChapter).mapToInt(SagaChapter::getNumber).sum();
        return SagaAbility.isFinalAbility((Ability)stackObject.getStackAbility(), (int)maxChapter);
    }
}

