/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.h.HiveMindEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HiveMindTriggeredAbility
extends TriggeredAbilityImpl {
    public HiveMindTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new HiveMindEffect());
        this.setTriggerPhrase("Whenever a player casts an instant or sorcery spell, ");
    }

    private HiveMindTriggeredAbility(HiveMindTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HiveMindTriggeredAbility copy() {
        return new HiveMindTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && (spell.isInstant(game) || spell.isSorcery(game))) {
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof HiveMindEffect)) continue;
                effect.setTargetPointer((TargetPointer)new FixedTarget(spell.getId()));
            }
            return true;
        }
        return false;
    }
}

