/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.DomainValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.InsectToken;

class HiveheartShamanEffect
extends OneShotEffect {
    HiveheartShamanEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 green Insect creature token. Put X +1/+1 counters on it, where X is the number of basic land types among lands you control";
    }

    private HiveheartShamanEffect(HiveheartShamanEffect effect) {
        super((OneShotEffect)effect);
    }

    public HiveheartShamanEffect copy() {
        return new HiveheartShamanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        InsectToken token = new InsectToken();
        token.putOntoBattlefield(1, game, source);
        int domainCount = DomainValue.REGULAR.calculate(game, source, (Effect)this);
        if (domainCount < 1) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(domainCount), source, game);
        }
        return true;
    }
}

