/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetForSourceEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HoardingDragonEffect
extends OneShotEffect {
    HoardingDragonEffect() {
        super(Outcome.Exile);
        this.staticText = "search your library for an artifact card, exile it, then shuffle";
    }

    private HoardingDragonEffect(HoardingDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT);
        controller.searchLibrary(target, source, game);
        Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            ExileTargetForSourceEffect effect = new ExileTargetForSourceEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget()));
            effect.apply(game, source);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }

    public HoardingDragonEffect copy() {
        return new HoardingDragonEffect(this);
    }
}

