/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.common.ZoneChangeTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.cards.h.HofriGhostforgeReturnEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HofriGhostforgeEffect
extends OneShotEffect {
    HofriGhostforgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it. If you do, create a token that's a copy of that creature, except it's a Spirit in addition to its other types and it has \"When this creature leaves the battlefield, return the exiled card to its owner's graveyard.\"";
    }

    private HofriGhostforgeEffect(HofriGhostforgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public HofriGhostforgeEffect copy() {
        return new HofriGhostforgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        effect.withAdditionalSubType(SubType.SPIRIT);
        effect.addAdditionalAbilities(new Ability[]{new ZoneChangeTriggeredAbility(Zone.ALL, Zone.BATTLEFIELD, null, (Effect)new HofriGhostforgeReturnEffect(card, game), "When this creature leaves the battlefield, ", false)});
        effect.apply(game, source);
        return true;
    }
}

