/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardCardYouChooseTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.ManaUtil;

class HollowSpecterEffect
extends OneShotEffect {
    HollowSpecterEffect() {
        super(Outcome.Discard);
        this.staticText = "you may pay {X}. If you do, that player reveals X cards from their hand and you choose one of them. That player discards that card";
    }

    private HollowSpecterEffect(HollowSpecterEffect effect) {
        super((OneShotEffect)effect);
    }

    public HollowSpecterEffect copy() {
        return new HollowSpecterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (targetPlayer != null && controller != null && controller.chooseUse(Outcome.Benefit, "Pay {X}?", source, game)) {
            int payCount = ManaUtil.playerPaysXGenericMana((boolean)true, (String)"Hollow Specter", (Player)controller, (Ability)source, (Game)game);
            if (payCount > 0) {
                return new DiscardCardYouChooseTargetEffect(payCount).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

