/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class HomingLightningEffect
extends OneShotEffect {
    HomingLightningEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 4 damage to target creature and each other creature with the same name as that creature";
    }

    private HomingLightningEffect(HomingLightningEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (targetPermanent == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        if (CardUtil.haveEmptyName((MageObject)targetPermanent)) {
            filter.add((Predicate)new PermanentIdPredicate(targetPermanent.getId()));
        } else {
            filter.add((Predicate)new NamePredicate(targetPermanent.getName()));
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            if (creature == null) continue;
            creature.damage(4, source.getSourceId(), source, game, false, true);
        }
        return true;
    }

    public HomingLightningEffect copy() {
        return new HomingLightningEffect(this);
    }
}

