/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.cards.h.HoodedBlightfang;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HoodedBlightfangTriggeredAbility
extends TriggeredAbilityImpl {
    HoodedBlightfangTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect(), false);
    }

    private HoodedBlightfangTriggeredAbility(HoodedBlightfangTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Permanent damaged = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null || damaged == null || !StaticFilters.FILTER_PERMANENT_PLANESWALKER.match((Object)damaged, game) || !HoodedBlightfang.filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(damaged.getId(), damaged.getZoneChangeCounter(game)));
        return true;
    }

    public HoodedBlightfangTriggeredAbility copy() {
        return new HoodedBlightfangTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature you control with deathtouch deals damage to a planeswalker, destroy that planeswalker.";
    }
}

