/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class HorizonStoneEffect
extends ContinuousEffectImpl {
    HorizonStoneEffect() {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.Benefit);
        this.staticText = "if you would lose unspent mana, that mana becomes colorless instead";
    }

    private HorizonStoneEffect(HorizonStoneEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HorizonStoneEffect copy() {
        return new HorizonStoneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.getManaPool().setManaBecomesColorless(true);
        }
        return true;
    }
}

