/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HostOfTheHereafterDiesEffect
extends OneShotEffect {
    HostOfTheHereafterDiesEffect() {
        super(Outcome.Benefit);
        this.staticText = "put its counters on up to one target creature you control";
    }

    private HostOfTheHereafterDiesEffect(HostOfTheHereafterDiesEffect effect) {
        super((OneShotEffect)effect);
    }

    public HostOfTheHereafterDiesEffect copy() {
        return new HostOfTheHereafterDiesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent deadCreature = (Permanent)this.getValue("creatureDied");
        if (permanent == null || deadCreature == null) {
            return false;
        }
        Counters counters = deadCreature.getCounters(game);
        counters.values().stream().filter(counter -> counter.getCount() > 0).forEach(counter -> permanent.addCounters(counter, source, game));
        return true;
    }
}

