/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HotshotInvestigatorsEffect
extends OneShotEffect {
    HotshotInvestigatorsEffect() {
        super(Outcome.Benefit);
        this.staticText = "return up to one other target creature to its owner's hand. If you controlled it, investigate";
    }

    private HotshotInvestigatorsEffect(HotshotInvestigatorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public HotshotInvestigatorsEffect copy() {
        return new HotshotInvestigatorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        boolean flag = permanent.isControlledBy(source.getControllerId());
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (flag) {
            new InvestigateEffect().apply(game, source);
        }
        return true;
    }
}

