/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.util.functions.CopyTokenFunction;

class HourOfEternityEffect
extends OneShotEffect {
    HourOfEternityEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile X target creature cards from your graveyard. For each card exiled this way, create a token that's a copy of that card, except it's a 4/4 black Zombie";
    }

    private HourOfEternityEffect(HourOfEternityEffect effect) {
        super((OneShotEffect)effect);
    }

    public HourOfEternityEffect copy() {
        return new HourOfEternityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<Card> cardsToExile = new HashSet<Card>(this.getTargetPointer().getTargets(game, source).size());
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Card card = controller.getGraveyard().get(targetId, game);
                if (card == null) continue;
                cardsToExile.add(card);
            }
            controller.moveCardsToExile(cardsToExile, source, game, true, null, "");
            for (Card card : cardsToExile) {
                if (game.getState().getZone(card.getId()) != Zone.EXILED) continue;
                Token token = CopyTokenFunction.createTokenCopy((Card)card, (Game)game);
                token.removePTCDA();
                token.setPower(4);
                token.setToughness(4);
                token.setColor(ObjectColor.BLACK);
                token.removeAllCreatureTypes();
                token.addSubType(new SubType[]{SubType.ZOMBIE});
                token.putOntoBattlefield(1, game, source, source.getControllerId());
            }
            return true;
        }
        return false;
    }
}

