/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HubrisReturnEffect
extends OneShotEffect {
    private static final FilterEnchantmentPermanent filter = new FilterEnchantmentPermanent();

    public HubrisReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature and all Auras attached to it to their owners' hands";
    }

    private HubrisReturnEffect(HubrisReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public HubrisReturnEffect copy() {
        return new HubrisReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent creature = game.getPermanent(targetId);
                if (creature == null) continue;
                CardsImpl cardsToHand = new CardsImpl();
                for (UUID cardId : creature.getAttachments()) {
                    Permanent card = game.getPermanent(cardId);
                    if (card == null || !card.hasSubtype(SubType.AURA, game)) continue;
                    cardsToHand.add((Card)card);
                }
                cardsToHand.add((Card)creature);
                controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.AURA.getPredicate());
    }
}

