/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HuntedWumpusEffect
extends OneShotEffect {
    HuntedWumpusEffect() {
        super(Outcome.Detriment);
        this.staticText = "each other player may put a creature card from their hand onto the battlefield";
    }

    private HuntedWumpusEffect(HuntedWumpusEffect effect) {
        super((OneShotEffect)effect);
    }

    public HuntedWumpusEffect copy() {
        return new HuntedWumpusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                if (playerId.equals(controller.getId())) continue;
                PutCardFromHandOntoBattlefieldEffect effect = new PutCardFromHandOntoBattlefieldEffect((FilterCard)StaticFilters.FILTER_CARD_CREATURE_A, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(playerId));
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

