/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class HuntersInsightTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference mor;

    HuntersInsightTriggeredAbility(MageObjectReference mor) {
        super(null, Duration.EndOfTurn, false, false);
        this.mor = mor;
    }

    private HuntersInsightTriggeredAbility(HuntersInsightTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
    }

    public HuntersInsightTriggeredAbility copy() {
        return new HuntersInsightTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER || event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.mor.refersTo(event.getSourceId(), game) || !((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && !permanent.isPlaneswalker(game)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new DrawCardSourceControllerEffect(event.getAmount()));
        return true;
    }

    public String getRule() {
        return "Whenever this creature deals combat damage to a player or planeswalker, draw that many cards.";
    }
}

