/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.common.CantBeCounteredSourceAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceTargetsPermanentCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageWithPowerFromOneToAnotherTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

public final class HuntersMark
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("creature or planeswalker you don't control");
    private static final FilterPermanent conditionFilter = new FilterPermanent("a blue permanent you don't control");
    private static final Condition condition;

    public HuntersMark(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{3}{G}");
        this.addAbility(new CantBeCounteredSourceAbility().setRuleAtTheTop(true));
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(3, condition).setCanWorksOnStackOnly(true)).setRuleAtTheTop(true));
        this.getSpellAbility().addTarget((Target)new TargetControlledCreaturePermanent());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter));
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(1, 1));
        this.getSpellAbility().addEffect((Effect)new DamageWithPowerFromOneToAnotherTargetEffect("it").concatBy("Then"));
    }

    private HuntersMark(HuntersMark card) {
        super((CardImpl)card);
    }

    public HuntersMark copy() {
        return new HuntersMark(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
        conditionFilter.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
        conditionFilter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
        condition = new SourceTargetsPermanentCondition(conditionFilter);
    }
}

