/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.h.HurkylMasterWizardTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class HurkylMasterWizardEffect
extends OneShotEffect {
    HurkylMasterWizardEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top five cards of your library. For each card type among noncreature spells you've cast this turn, you may put a card of that type from among the revealed cards into your hand. Put the rest on the bottom of your library in a random order";
    }

    private HurkylMasterWizardEffect(HurkylMasterWizardEffect effect) {
        super((OneShotEffect)effect);
    }

    public HurkylMasterWizardEffect copy() {
        return new HurkylMasterWizardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
        player.revealCards(source, (Cards)cards, game);
        HurkylMasterWizardTarget target = new HurkylMasterWizardTarget(source, game);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toHand = new CardsImpl((Collection)target.getTargets());
        player.moveCardsToHandWithInfo((Cards)toHand, source, game, true);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

