/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.CardTypeAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.h.HurkylMasterWizardWatcher;
import mage.constants.CardType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class HurkylMasterWizardTarget
extends TargetCardInLibrary {
    private final CardTypeAssignment cardTypeAssigner;

    HurkylMasterWizardTarget(Ability source, Game game) {
        super(0, Integer.MAX_VALUE, StaticFilters.FILTER_CARD);
        this.cardTypeAssigner = new CardTypeAssignment(HurkylMasterWizardWatcher.getCardTypes(source, game).toArray(new CardType[0]));
    }

    private HurkylMasterWizardTarget(HurkylMasterWizardTarget target) {
        super((TargetCardInLibrary)target);
        this.cardTypeAssigner = target.cardTypeAssigner;
    }

    public HurkylMasterWizardTarget copy() {
        return new HurkylMasterWizardTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return this.cardTypeAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }
}

