/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.DiscoverEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;

class HurlIntoHistoryEffect
extends OneShotEffect {
    HurlIntoHistoryEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target artifact or creature spell. Discover X, where X is that spell's mana value.";
    }

    private HurlIntoHistoryEffect(HurlIntoHistoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public HurlIntoHistoryEffect copy() {
        return new HurlIntoHistoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackObject == null) {
            return false;
        }
        game.getStack().counter(source.getFirstTarget(), source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            DiscoverEffect.doDiscover((Player)player, (int)stackObject.getManaValue(), (Game)game, (Ability)source);
        }
        return true;
    }
}

