/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class HydroidKrasisEffect
extends OneShotEffect {
    HydroidKrasisEffect() {
        super(Outcome.Benefit);
        this.staticText = "you gain half X life and draw half X cards. Round down each time.";
    }

    private HydroidKrasisEffect(HydroidKrasisEffect effect) {
        super((OneShotEffect)effect);
    }

    public HydroidKrasisEffect copy() {
        return new HydroidKrasisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Object obj = this.getValue("sourceCastSpellAbility");
        if (!(obj instanceof SpellAbility)) {
            return false;
        }
        int halfCost = Math.floorDiv((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)((SpellAbility)obj), (String)"X", (Object)0), 2);
        player.drawCards(halfCost, source, game);
        player.gainLife(halfCost, game, source);
        return true;
    }
}

