/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class IanMalcolmChaoticianWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<MageObjectReference>> exiledMap = new HashMap<MageObjectReference, Set<MageObjectReference>>();
    private final Map<MageObjectReference, Set<UUID>> usedMap = new HashMap<MageObjectReference, Set<UUID>>();

    IanMalcolmChaoticianWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST && event.hasApprovingIdentifier(MageIdentifier.IanMalcolmChaoticianWatcher)) {
            this.usedMap.computeIfAbsent(event.getApprovingObject().getApprovingMageObjectReference(), x -> new HashSet()).add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.usedMap.clear();
    }

    static void addCard(MageObjectReference sourceObj, Card card, Game game) {
        Set set = ((IanMalcolmChaoticianWatcher)game.getState().getWatcher(IanMalcolmChaoticianWatcher.class)).exiledMap.computeIfAbsent(sourceObj, x -> new HashSet());
        MageObjectReference mor = new MageObjectReference((MageObject)card, game);
        set.add(mor);
    }

    static boolean checkUsed(Ability source, Game game) {
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject == null) {
            return true;
        }
        return ((IanMalcolmChaoticianWatcher)game.getState().getWatcher(IanMalcolmChaoticianWatcher.class)).usedMap.getOrDefault(new MageObjectReference((MageObject)sourceObject, game), Collections.emptySet()).contains(source.getControllerId());
    }

    static boolean checkExile(MageObjectReference sourceObj, Card card, Game game, int offset) {
        return ((IanMalcolmChaoticianWatcher)game.getState().getWatcher(IanMalcolmChaoticianWatcher.class)).exiledMap.getOrDefault(sourceObj, Collections.emptySet()).stream().anyMatch(mor -> mor.refersTo((MageObject)card, game, offset));
    }
}

