/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class IcatianSkirmishersEffect
extends OneShotEffect {
    IcatianSkirmishersEffect() {
        super(Outcome.AddAbility);
        this.staticText = "all creatures banded with it gain first strike until end of turn";
    }

    private IcatianSkirmishersEffect(IcatianSkirmishersEffect effect) {
        super((OneShotEffect)effect);
    }

    public IcatianSkirmishersEffect copy() {
        return new IcatianSkirmishersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            for (UUID bandedId : sourcePermanent.getBandedCards()) {
                Permanent banded = game.getPermanent(bandedId);
                if (banded == null || banded.getBandedCards() == null || !banded.getBandedCards().contains(sourcePermanent.getId())) continue;
                GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(bandedId, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

