/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.i.IchneumonDruidWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class IchneumonDruidAbility
extends TriggeredAbilityImpl {
    public IchneumonDruidAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)StaticValue.get((int)4), false, "that player", true));
    }

    private IchneumonDruidAbility(IchneumonDruidAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public IchneumonDruidAbility copy() {
        return new IchneumonDruidAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        IchneumonDruidWatcher watcher;
        Spell spell;
        if (!event.getPlayerId().equals(this.controllerId) && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isInstant(game) && (watcher = (IchneumonDruidWatcher)game.getState().getWatcher(IchneumonDruidWatcher.class)) != null && watcher.moreThanTwoInstantsCast(event.getPlayerId(), game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent casts an instant spell other than the first instant spell that player casts each turn, {this} deals 4 damage to that player.";
    }
}

