/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class IchorplateGolemTriggeredAbility
extends TriggeredAbilityImpl {
    public IchorplateGolemTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.OIL.createInstance()));
    }

    private IchorplateGolemTriggeredAbility(IchorplateGolemTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            return false;
        }
        if (permanent.isControlledBy(this.controllerId) && permanent.getCounters(game).getCount(CounterType.OIL) > 0) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            }
            return true;
        }
        return false;
    }

    public IchorplateGolemTriggeredAbility copy() {
        return new IchorplateGolemTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature you control enters, if it has one or more oil counters on it, put an oil counter on it.";
    }
}

