/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;

class IconOfAncestryEffect
extends OneShotEffect {
    IconOfAncestryEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "look at the top three cards of your library. You may reveal a creature card of the chosen type from among them and put it into your hand. Put the rest on the bottom of your library in a random order";
    }

    public boolean apply(Game game, Ability source) {
        SubType subtype = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        if (subtype == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard(subtype.toString() + " creature card");
        filter.add((Predicate)subtype.getPredicate());
        return new LookLibraryAndPickControllerEffect(3, 1, (FilterCard)filter, PutCards.HAND, PutCards.BOTTOM_RANDOM).apply(game, source);
    }

    private IconOfAncestryEffect(IconOfAncestryEffect effect) {
        super((OneShotEffect)effect);
    }

    public IconOfAncestryEffect copy() {
        return new IconOfAncestryEffect(this);
    }
}

