/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class IdentityThiefEffect
extends OneShotEffect {
    IdentityThiefEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may exile another target nontoken creature. If you do, {this} becomes a copy of that creature until end of turn. Return the exiled card to the battlefield under its owner's control at the beginning of the next end step";
    }

    private IdentityThiefEffect(IdentityThiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetPermanent == null) {
            return false;
        }
        controller.moveCardsToExile((Card)targetPermanent, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, true).setText("Return the exiled card to the battlefield under its owner's control at the beginning of the next end step").setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game))), source);
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent != null) {
            game.addEffect(new CopyEffect(Duration.EndOfTurn, (MageObject)targetPermanent, source.getSourceId()).setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent.getId(), game)), source);
        }
        return true;
    }

    public IdentityThiefEffect copy() {
        return new IdentityThiefEffect(this);
    }
}

