/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class IlluminationEffect
extends OneShotEffect {
    IlluminationEffect() {
        super(Outcome.GainLife);
        this.staticText = "Its controller gains life equal to its mana value";
    }

    private IlluminationEffect(IlluminationEffect effect) {
        super((OneShotEffect)effect);
    }

    public IlluminationEffect copy() {
        return new IlluminationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = source.getFirstTarget();
        Player controller = null;
        boolean countered = false;
        if (targetId != null) {
            controller = game.getPlayer(game.getControllerId(targetId));
        }
        if (targetId != null && game.getStack().counter(targetId, source, game)) {
            countered = true;
        }
        if (controller != null) {
            Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
            int cost = spell.getManaValue();
            Player player = game.getPlayer(spell.getControllerId());
            if (player != null) {
                player.gainLife(cost, game, source);
            }
            return true;
        }
        return countered;
    }
}

