/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class IllunaApexOfWishesEffect
extends OneShotEffect {
    IllunaApexOfWishesEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile a nonland permanent card. Put that card onto the battlefield or into your hand";
    }

    private IllunaApexOfWishesEffect(IllunaApexOfWishesEffect effect) {
        super((OneShotEffect)effect);
    }

    public IllunaApexOfWishesEffect copy() {
        return new IllunaApexOfWishesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card permCard = null;
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (card == null || card.isLand(game) || !card.isPermanent(game)) continue;
            permCard = card;
            break;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        if (permCard == null) {
            return true;
        }
        Zone zone = player.chooseUse(this.outcome, "Put " + permCard.getName() + " into your hand or onto the battlefield?", "", "Hand", "Battlefield", source, game) ? Zone.HAND : Zone.BATTLEFIELD;
        return player.moveCards(permCard, zone, source, game);
    }
}

