/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.i.IllusionistsGambitRequirementEffect;
import mage.cards.i.IllusionistsGambitRestrictionEffect;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.Phase;
import mage.game.turn.TurnMod;

class IllusionistsGambitRemoveFromCombatEffect
extends OneShotEffect {
    IllusionistsGambitRemoveFromCombatEffect() {
        super(Outcome.Benefit);
        this.staticText = "Remove all attacking creatures from combat and untap them. After this phase, there is an additional combat phase. Each of those creatures attacks that combat if able. They can't attack you or planeswalkers you control that combat";
    }

    private IllusionistsGambitRemoveFromCombatEffect(IllusionistsGambitRemoveFromCombatEffect effect) {
        super((OneShotEffect)effect);
    }

    public IllusionistsGambitRemoveFromCombatEffect copy() {
        return new IllusionistsGambitRemoveFromCombatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set attackers = game.getCombat().getAttackers();
        for (UUID attackerId : attackers) {
            Permanent creature = game.getPermanent(attackerId);
            if (creature == null) continue;
            creature.removeFromCombat(game);
            creature.untap(game);
        }
        if (!attackers.isEmpty()) {
            Phase phase = game.getTurn().getPhase();
            game.getState().getTurnMods().add(new TurnMod(game.getActivePlayerId()).withExtraPhase(TurnPhase.COMBAT));
            Object effect = new IllusionistsGambitRequirementEffect(attackers, phase);
            game.addEffect((ContinuousEffect)effect, source);
            effect = new IllusionistsGambitRestrictionEffect(attackers, phase);
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

