/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.Phase;

class IllusionistsGambitRestrictionEffect
extends RestrictionEffect {
    private final Set<UUID> attackers;
    private final Phase phase;

    public IllusionistsGambitRestrictionEffect(Set<UUID> attackers, Phase phase) {
        super(Duration.Custom, Outcome.Benefit);
        this.attackers = attackers;
        this.phase = phase;
        this.staticText = "They can't attack you or planeswalkers you control that combat";
    }

    private IllusionistsGambitRestrictionEffect(IllusionistsGambitRestrictionEffect effect) {
        super((RestrictionEffect)effect);
        this.attackers = effect.attackers;
        this.phase = effect.phase;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.attackers.contains(permanent.getId());
    }

    public boolean isInactive(Ability source, Game game) {
        if (game.getTurnStepType() == PhaseStep.END_COMBAT) {
            return !Objects.equals(game.getTurn().getPhase(), this.phase);
        }
        return false;
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null) {
            return true;
        }
        if (defenderId.equals(source.getControllerId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(defenderId);
        return permanent == null || !permanent.isControlledBy(source.getControllerId()) || !permanent.isPlaneswalker(game);
    }

    public IllusionistsGambitRestrictionEffect copy() {
        return new IllusionistsGambitRestrictionEffect(this);
    }
}

