/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ImmerwolfEffect
extends RestrictionEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent(SubType.WEREWOLF);

    ImmerwolfEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Non-Human Werewolves you control can't transform";
    }

    private ImmerwolfEffect(ImmerwolfEffect effect) {
        super((RestrictionEffect)effect);
    }

    public ImmerwolfEffect copy() {
        return new ImmerwolfEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return filter.match(permanent, source.getControllerId(), source, game);
    }

    public boolean canTransform(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.HUMAN.getPredicate()));
    }
}

