/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValuePositiveHint;
import mage.cards.i.ImodaneThePyrohammerDynamicValue;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.StaticFilters;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.other.HasOnlySingleTargetPermanentPredicate;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForPermanentsEvent;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class ImodaneThePyrohammerTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    private static final FilterSpell filter = new FilterInstantOrSorcerySpell("instant or sorcery spell you control that targets only a single creature");
    private static final Hint hint;

    ImodaneThePyrohammerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamagePlayersEffect(Outcome.Damage, (DynamicValue)ImodaneThePyrohammerDynamicValue.instance, TargetController.OPPONENT).setText("{this} deals that much damage to each opponent"), false);
        this.setTriggerPhrase("Whenever an instant or sorcery spell you control that targets only a single creature deals damage to that creature, ");
        this.addHint(hint);
    }

    private ImodaneThePyrohammerTriggeredAbility(ImodaneThePyrohammerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ImodaneThePyrohammerTriggeredAbility copy() {
        return new ImodaneThePyrohammerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_PERMANENTS;
    }

    public boolean checkEvent(DamagedPermanentEvent event, Game game) {
        MageObject sourceObject = game.getObject(event.getSourceId());
        Permanent target = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return target != null && sourceObject instanceof StackObject && filter.match((StackObject)sourceObject, this.getControllerId(), (Ability)this, game) && target.getId().equals(((StackObject)sourceObject).getStackAbility().getFirstTarget());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int damage = this.getFilteredEvents((BatchEvent)((DamagedBatchForPermanentsEvent)event), game).stream().mapToInt(GameEvent::getAmount).sum();
        if (damage < 1) {
            return false;
        }
        this.getEffects().setValue("Imodane-Damage-Amount", (Object)damage);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((ObjectSourcePlayerPredicate)new HasOnlySingleTargetPermanentPredicate((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE));
        hint = new ValuePositiveHint("Damage dealt to the target", (DynamicValue)ImodaneThePyrohammerDynamicValue.instance);
    }
}

