/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ImpromptuRaidEffect
extends OneShotEffect {
    private static final FilterCard filterPutInGraveyard = new FilterCard("noncreature card to put into your graveyard");

    public ImpromptuRaidEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal the top card of your library. If it isn't a creature card, put it into your graveyard. Otherwise, put that card onto the battlefield. That creature gains haste. Sacrifice it at the beginning of the next end step";
    }

    private ImpromptuRaidEffect(ImpromptuRaidEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImpromptuRaidEffect copy() {
        return new ImpromptuRaidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null && (card = controller.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl();
            cards.add(card);
            controller.revealCards(sourceObject.getName(), (Cards)cards, game);
            if (filterPutInGraveyard.match(card, source.getControllerId(), source, game)) {
                controller.moveCards(card, Zone.GRAVEYARD, source, game);
                return true;
            }
            if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
                Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                if (permanent != null) {
                    GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                    SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("", source.getControllerId());
                    sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                    game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                }
                return true;
            }
        }
        return false;
    }

    static {
        filterPutInGraveyard.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

