/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class ImpsMischiefLoseLifeEffect
extends OneShotEffect {
    public ImpsMischiefLoseLifeEffect() {
        super(Outcome.LoseLife);
        this.staticText = "You lose life equal to that spell's mana value";
    }

    private ImpsMischiefLoseLifeEffect(ImpsMischiefLoseLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImpsMischiefLoseLifeEffect copy() {
        return new ImpsMischiefLoseLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Spell spell = game.getStack().getSpell(source.getFirstTarget());
        if (spell != null && (player = game.getPlayer(source.getControllerId())) != null) {
            player.loseLife(spell.getManaValue(), game, source, false);
            return true;
        }
        return false;
    }
}

