/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class ImpulsiveWagerEffect
extends OneShotEffect {
    ImpulsiveWagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "If the discarded card was a nonland card, draw two cards. Otherwise, put a bounty counter on target creature";
    }

    private ImpulsiveWagerEffect(ImpulsiveWagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            DiscardCardCost cost = (DiscardCardCost)source.getCosts().get(0);
            if (cost != null) {
                List cards = cost.getCards();
                if (cards.size() == 1 && ((Card)cards.get(0)).isLand(game)) {
                    AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.BOUNTY.createInstance());
                    effect.setTargetPointer(this.getTargetPointer().copy());
                    effect.apply(game, source);
                } else {
                    player.drawCards(2, source, game);
                }
            }
            return true;
        }
        return false;
    }

    public ImpulsiveWagerEffect copy() {
        return new ImpulsiveWagerEffect(this);
    }
}

