/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.filter.predicate.mageobject.PermanentPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class InSearchOfGreatnessEffect
extends OneShotEffect {
    InSearchOfGreatnessEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may cast a permanent spell from your hand with mana value equal to 1 plus the highest mana value among other permanents you control without paying its mana cost. If you don't, scry 1";
    }

    private InSearchOfGreatnessEffect(InSearchOfGreatnessEffect effect) {
        super((OneShotEffect)effect);
    }

    public InSearchOfGreatnessEffect copy() {
        return new InSearchOfGreatnessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int manaValue = GreatestAmongPermanentsValue.MANAVALUE_OTHER_CONTROLLED_PERMANENTS.calculate(game, source, (Effect)this);
        FilterPermanentCard filter = new FilterPermanentCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, manaValue + 1));
        filter.add((Predicate)PermanentPredicate.instance);
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)controller.getHand()), (FilterCard)filter) || controller.scry(1, source, game);
    }
}

