/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.CantBlockAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InciteHysteriaEffect
extends OneShotEffect {
    InciteHysteriaEffect() {
        super(Outcome.AddAbility);
        this.staticText = "Until end of turn, target creature and each other creature that shares a color with it gain \"This creature can't block.\"";
    }

    private InciteHysteriaEffect(InciteHysteriaEffect effect) {
        super((OneShotEffect)effect);
    }

    public InciteHysteriaEffect copy() {
        return new InciteHysteriaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (target != null) {
                ObjectColor color = target.getColor(game);
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                    if (!permanent.getColor(game).shares(color)) continue;
                    GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)new CantBlockAbility(), Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

