/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class InciteRebellionEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public InciteRebellionEffect() {
        super(Outcome.Detriment);
        this.staticText = "For each player, {this} deals damage to that player and each creature that player controls equal to the number of creatures they control";
    }

    private InciteRebellionEffect(InciteRebellionEffect effect) {
        super((OneShotEffect)effect);
    }

    public InciteRebellionEffect copy() {
        return new InciteRebellionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                int count;
                Player player = game.getPlayer(playerId);
                if (player == null || (count = game.getBattlefield().countAll((FilterPermanent)filter, playerId, game)) <= 0) continue;
                player.damage(count, source.getSourceId(), source, game);
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, playerId, game)) {
                    permanent.damage(count, source.getSourceId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

