/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class IncomingEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("artifact, creature, enchantment, and/or land cards");

    public IncomingEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player searches their library for any number of artifact, creature, enchantment, and/or land cards, puts them onto the battlefield, then shuffles";
    }

    private IncomingEffect(IncomingEffect effect) {
        super((OneShotEffect)effect);
    }

    public IncomingEffect copy() {
        return new IncomingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetCardInLibrary target;
                Player player = game.getPlayer(playerId);
                if (player == null || !player.searchLibrary(target = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter), source, game)) continue;
                player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
                player.shuffleLibrary(source, game);
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

