/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class IndenturedOafPreventEffectEffect
extends PreventionEffectImpl {
    IndenturedOafPreventEffectEffect(Duration duration) {
        super(duration, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that {this} would deal to red creatures";
    }

    private IndenturedOafPreventEffectEffect(IndenturedOafPreventEffectEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public IndenturedOafPreventEffectEffect copy() {
        return new IndenturedOafPreventEffectEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event.getSourceId().equals(source.getSourceId())) {
            Permanent damageTo = game.getPermanent(event.getTargetId());
            return damageTo != null && damageTo.getColor(game).isRed();
        }
        return false;
    }
}

