/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;

class InduceParanoiaEffect
extends OneShotEffect {
    InduceParanoiaEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. If {B} was spent to cast this spell, that spell's controller mills X cards, where X is the spell's mana value.";
    }

    private InduceParanoiaEffect(InduceParanoiaEffect effect) {
        super((OneShotEffect)effect);
    }

    public InduceParanoiaEffect copy() {
        return new InduceParanoiaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            game.getStack().counter(spell.getId(), source, game);
            int spellCMC = spell.getManaValue();
            Player player = game.getPlayer(spell.getControllerId());
            if (player != null) {
                player.millCards(spellCMC, source, game);
                return true;
            }
        }
        return false;
    }
}

