/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class InducedAmnesiaReturnEffect
extends OneShotEffect {
    InducedAmnesiaReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return the exiled cards to their owner's hand";
    }

    private InducedAmnesiaReturnEffect(InducedAmnesiaReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public InducedAmnesiaReturnEffect copy() {
        return new InducedAmnesiaReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject mageObject = game.getObject(source.getSourceId());
        if (mageObject == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)mageObject.getId(), (int)(game.getState().getZoneChangeCounter(mageObject.getId()) - 1)));
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        Set cards = exileZone.getCards(game);
        HashMap<UUID, Cards> cardsByOwner = new HashMap<UUID, Cards>();
        for (Card card : cards) {
            cardsByOwner.computeIfAbsent(card.getOwnerId(), k -> new CardsImpl()).add(card);
        }
        for (Map.Entry entry : cardsByOwner.entrySet()) {
            Player owner = game.getPlayer((UUID)entry.getKey());
            if (owner == null) continue;
            owner.moveCards((Cards)entry.getValue(), Zone.HAND, source, game);
        }
        return true;
    }
}

