/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class IndulgentTormentorEffect
extends OneShotEffect {
    IndulgentTormentorEffect() {
        super(Outcome.DrawCard);
        this.staticText = "draw a card unless target opponent sacrifices a creature or pays 3 life";
    }

    private IndulgentTormentorEffect(IndulgentTormentorEffect effect) {
        super((OneShotEffect)effect);
    }

    public IndulgentTormentorEffect copy() {
        return new IndulgentTormentorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent != null) {
            SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            if (cost.canPay(source, source, opponent.getId(), game) && opponent.chooseUse(this.outcome, "Sacrifice a creature to prevent the card draw?", source, game) && cost.pay(source, game, source, opponent.getId(), false, null)) {
                return true;
            }
            cost = new PayLifeCost(3);
            if (cost.canPay(source, source, opponent.getId(), game) && opponent.chooseUse(this.outcome, "Pay 3 life to prevent the card draw?", source, game) && cost.pay(source, game, source, opponent.getId(), false, null)) {
                return true;
            }
            game.getPlayer(source.getControllerId()).drawCards(1, source, game);
            return true;
        }
        return false;
    }
}

