/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DiesAttachedTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.combat.AttacksIfAbleAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCreaturePermanent;

public final class InfectiousBloodlust
extends CardImpl {
    private static final FilterCard filter = new FilterCard("card named Infectious Bloodlust");

    public InfectiousBloodlust(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(2, 1));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)HasteAbility.getInstance(), AttachmentType.AURA).setText(", has haste"));
        ability.addEffect((Effect)new AttacksIfAbleAttachedEffect(Duration.WhileOnBattlefield, AttachmentType.AURA).setText(", and attacks each combat if able"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new DiesAttachedTriggeredAbility((Effect)new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true), "enchanted creature", true));
    }

    private InfectiousBloodlust(InfectiousBloodlust card) {
        super((CardImpl)card);
    }

    public InfectiousBloodlust copy() {
        return new InfectiousBloodlust(this);
    }

    static {
        filter.add((Predicate)new NamePredicate("Infectious Bloodlust"));
    }
}

