/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class InfernalTutorEffect
extends OneShotEffect {
    InfernalTutorEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal a card from your hand. Search your library for a card with the same name as that card, reveal it, put it into your hand, then shuffle";
    }

    private InfernalTutorEffect(InfernalTutorEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfernalTutorEffect copy() {
        return new InfernalTutorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            if (!controller.getHand().isEmpty()) {
                FilterCard filterCard;
                Card cardToReveal = null;
                if (controller.getHand().size() > 1) {
                    TargetCardInHand target = new TargetCardInHand(StaticFilters.FILTER_CARD);
                    target.withNotTarget(true);
                    if (controller.chooseTarget(this.outcome, (Target)target, source, game)) {
                        cardToReveal = game.getCard(target.getFirstTarget());
                    }
                } else {
                    cardToReveal = controller.getHand().getRandom(game);
                }
                if (cardToReveal != null) {
                    controller.revealCards("from hand :" + sourceObject.getName(), (Cards)new CardsImpl(cardToReveal), game);
                    String nameToSearch = CardUtil.getCardNameForSameNameSearch((Card)cardToReveal);
                    filterCard = new FilterCard("card named " + nameToSearch);
                    filterCard.add((Predicate)new NamePredicate(nameToSearch));
                } else {
                    filterCard = new FilterCard();
                }
                return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filterCard), true).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

