/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldWithCounterTargetEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class InfernalVesselReturnEffect
extends OneShotEffect {
    InfernalVesselReturnEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return it to the battlefield under its owner's control with two +1/+1 counters on it. It's a Demon in addition to its other types";
    }

    private InfernalVesselReturnEffect(InfernalVesselReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfernalVesselReturnEffect copy() {
        return new InfernalVesselReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        ReturnFromGraveyardToBattlefieldWithCounterTargetEffect effect = new ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(new Counter[]{CounterType.P1P1.createInstance(2)});
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        effect.apply(game, source);
        game.processAction();
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            game.addEffect(new AddCardSubTypeTargetEffect(SubType.DEMON, Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

