/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class InfernoTrapWatcher
extends Watcher {
    private Map<UUID, Set<MageObjectReference>> playerDamagedByCreature = new HashMap<UUID, Set<MageObjectReference>>();

    public InfernoTrapWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent damageBy;
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && event.getTargetId().equals(this.controllerId) && (damageBy = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null && damageBy.isCreature(game)) {
            Set damagingCreatures = this.playerDamagedByCreature.getOrDefault(event.getTargetId(), new HashSet());
            MageObjectReference damagingCreature = new MageObjectReference((MageObject)damageBy, game);
            damagingCreatures.add(damagingCreature);
            this.playerDamagedByCreature.put(event.getTargetId(), damagingCreatures);
        }
    }

    public Set<MageObjectReference> getDamagingCreatures(UUID playerId) {
        return this.playerDamagedByCreature.getOrDefault(playerId, new HashSet());
    }

    public void reset() {
        super.reset();
        this.playerDamagedByCreature.clear();
    }
}

